(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4964,        202]*)
(*NotebookOutlinePosition[      5808,        229]*)
(*  CellTagsIndexPosition[      5764,        225]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ 
      Example\ 5.1 \( \(.2\)\(.\)\)\ *) \)\(\[IndentingNewLine]\)\( (*\ \
\[Psi]0 \((x)\)\ *) \)\(\ \)\(Integrate[\((\ \((x - s)\)^2 - 1)\), \ {s, \ 
        x - 1, 1}]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(-\(4\/3\)\) + x\^2 - x\^3\/3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ \[Psi]1 \((x)\)\ *) \ 
    Integrate[\((\ \((x - s)\)^2 - 1)\)*s^2, \ {s, \ x - 1, 1}]\ \ \)\)], 
  "Input"],

Cell[BoxData[
    \(\(-\(4\/15\)\) - x\^2\/3 + x\^3\/3 - x\^5\/30\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ B_  00\ *) \ Integrate[\ 1, \ {s, \(-1\), 1}]\)\)], "Input"],

Cell[BoxData[
    \(2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ B_  01 = B_  10\ *) \ Integrate\ [s^2, \ {s, \ \(-1\), 1}]\)\)], 
  "Input"],

Cell[BoxData[
    \(2\/3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ B_  11\ *) \ \ Integrate[s^4, \ {s, \(-1\), 1}]\)\)], "Input"],

Cell[BoxData[
    \(2\/5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ A_  00\ *) \ \ 
    2*Integrate[\((\(-\(4\/3\)\) + x\^2 - x\^3\/3)\), \ {x, \ 0, 1}]\)\)], 
  "Input"],

Cell[BoxData[
    \(\(-\(13\/6\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ A_  01*) \ \ 
    2*Integrate[x^2 \((\(-\(4\/3\)\) + x\^2 - x\^3\/3)\), \ {x, \ 0, 1}]
        \)\)], "Input"],

Cell[BoxData[
    \(\(-\(3\/5\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ A_  10\ *) \ \ 
    2*Integrate[\((\(-\(4\/15\)\) - x\^2\/3 + x\^3\/3 - x\^5\/30)\), 
        \ {x, \ 0, 1}]\)\)], "Input"],

Cell[BoxData[
    \(\(-\(3\/5\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ A_  11\ *) 2*
      Integrate[x^2*\((\(-\(4\/15\)\) - x\^2\/3 + x\^3\/3 - x\^5\/30)\), 
        \ {x, \ 0, 1}]\)\)], "Input"],

Cell[BoxData[
    \(\(-\(5\/24\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ \[Gamma]_  1\ *) \ 
    Integrate[1/\((1 + x^2)\), \ {x, \(-1\), 1}]\)\)], "Input"],

Cell[BoxData[
    \(\[Pi]\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ \[Gamma]_  2\ *) \ 
    Integrate[x^2/\((1 + x^2)\), \ {x, \(-1\), 1}]\)\)], "Input"],

Cell[BoxData[
    \(1 + \(4 - \[Pi]\)\/4 - \[Pi]\/4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = {\ {2, \ 2/3}, \ {2/3, \ 2/5}}\  - {{\(-13\)/6, \ \(-3\)/5}, 
          \ {\(-3\)/5, \(-\ 5\)/24}}\)], "Input"],

Cell[BoxData[
    \({{25\/6, 19\/15}, {19\/15, 73\/120}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = {\[Pi]\/2, 1 + \(4 - \[Pi]\)\/4 - \[Pi]\/4}\)], "Input"],

Cell[BoxData[
    \({\[Pi]\/2, 1 + \(4 - \[Pi]\)\/4 - \[Pi]\/4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[m, b]\)], "Input"],

Cell[BoxData[
    \({\(15\ \((\(-608\) + 225\ \[Pi])\)\)\/3349, 
      \(-\(\(60\ \((\(-500\) + 163\ \[Pi])\)\)\/3349\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \({0.442781488762481778`, \(-0.216415691880613536`\)}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{12, Automatic}, {Automatic, 13}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 221, 4, 43, "Input"],
Cell[1963, 57, 64, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2064, 63, 135, 3, 43, "Input"],
Cell[2202, 68, 79, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2318, 74, 87, 1, 27, "Input"],
Cell[2408, 77, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2480, 83, 103, 2, 27, "Input"],
Cell[2586, 87, 38, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2661, 93, 89, 1, 27, "Input"],
Cell[2753, 96, 38, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2828, 102, 129, 3, 45, "Input"],
Cell[2960, 107, 48, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3045, 113, 137, 3, 45, "Input"],
Cell[3185, 118, 47, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3269, 124, 150, 3, 63, "Input"],
Cell[3422, 129, 47, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3506, 135, 152, 3, 63, "Input"],
Cell[3661, 140, 48, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3746, 146, 110, 2, 27, "Input"],
Cell[3859, 150, 42, 1, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3938, 156, 112, 2, 27, "Input"],
Cell[4053, 160, 65, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4155, 166, 135, 2, 43, "Input"],
Cell[4293, 170, 70, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4400, 176, 80, 1, 42, "Input"],
Cell[4483, 179, 77, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4597, 185, 50, 1, 27, "Input"],
Cell[4650, 188, 136, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4823, 195, 37, 1, 27, "Input"],
Cell[4863, 198, 85, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

